/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.ui.opengl;

import java.awt.Color;
import javax.media.opengl.GL;

public final class JoglColor {
    public static final JoglColor BLACK = new JoglColor(Color.BLACK);
    public static final JoglColor BLUE = new JoglColor(Color.BLUE);
    public static final JoglColor CYAN = new JoglColor(Color.CYAN);
    public static final JoglColor GREEN = new JoglColor(Color.GREEN.darker());
    public static final JoglColor MAGENTA = new JoglColor(Color.MAGENTA);
    public static final JoglColor ORANGE = new JoglColor(Color.ORANGE);
    public static final JoglColor PINK = new JoglColor(Color.PINK);
    public static final JoglColor RED = new JoglColor(Color.RED);
    public static final JoglColor WHITE = new JoglColor(Color.WHITE);
    public static final JoglColor YELLOW = new JoglColor(Color.YELLOW);
    private final float R;
    private final float G;
    private final float B;
    private final float A;

    public JoglColor(Color color) {
        this(color.getRGBComponents(null));
    }

    public JoglColor(float ... fArray) {
        if (fArray.length != 3 && fArray.length != 4) {
            throw new IllegalArgumentException("Invalid size for components array : " + fArray.length);
        }
        this.R = fArray[0];
        this.G = fArray[1];
        this.B = fArray[2];
        this.A = fArray.length > 3 ? fArray[3] : 1.0f;
    }

    void apply(GL gL) {
        gL.glColor4f(this.R, this.G, this.B, this.A);
    }

    void apply(GL gL, float f) {
        gL.glColor4f(this.R, this.G, this.B, f);
    }

    public JoglColor darker() {
        return new JoglColor(new Color(this.R, this.G, this.B, this.A).darker());
    }

    public JoglColor brighter() {
        return new JoglColor(new Color(this.R, this.G, this.B, this.A).brighter());
    }
}

